from .. import _xmsconstraint


class Contourer:
    """Computes 2D contours for triangles."""

    def __init__(self, contour_values, nodata_value, tolerance):
        """init function.

        Args:
			contour_values: The contour values you're contouring.
			no_data_value: The no data value (scalars with these values are ignored).
			tolerance: The contour tolerance.
        """
        self._instance = _xmsconstraint.contour.XmContourer(contour_values, nodata_value, tolerance)

    def contour_3_points(self, point_locations, point_scalars):
        """Contours 3 points given the point locations, their values, etc.

        Args:
			point_locations: The point locations.
			point_scalars: The point scalars.
        """
        self._instance.Contour3Points(point_locations, point_scalars)

    def get_contour_segments(self):
        """Get all the current contour lines stored in this class from calling contour_3_points.

        Returns:
		    A map containing the unsorted contour segments for each value (the value is the key)
        """
        segments = self._instance.GetContourSegments()
        return_segments = {}
        for value, segments in segments.items():
            return_segments[value] = segments.tolist()
        return return_segments
