from . import _xmsconstraint
from . import Grid
from .grid import GridType


class UGrid2d(Grid):
    """A constrained UGrid containing only 2D cells."""
    def __init__(self, ugrid=None, instance=None):
        """Initializer for UGrid2d. Must be given either a UGrid or a C++ instance.

        Args:
            ugrid: An optional UGrid.
            instance: An optional C++ instance.
        """
        if ugrid:
            instance = _xmsconstraint.constraint.CoUGrid2d(ugrid._instance)
        if not instance:
            raise ValueError('Attempted to make a UGrid2d without a ugrid '
                             'or instance.')
        Grid.__init__(self, instance)

    @property
    def grid_type(self):
        """GridType of the constraint."""
        return GridType.ugrid_2d
