# 1. Standard python modules
from typing import Sequence, Union

# 2. Third party modules

# 3. Aquaveo modules
from xms.grid.ugrid import UGrid

# 4. Local modules
from . import _xmsconstraint
from xms.constraint import Grid


class UGridBoundaries:
    """Get UGrid Boundaries."""

    def __init__(self, grid: Union[Grid, UGrid, None] = None, target_cells: bool = False,
                 cell_values: Union[Sequence, None] = None):
        """Initializer for UGridBoundaries.

        Args:
            grid (Grid): Grid to find the boundaries of.
            target_cells: Whether to look for cell or point boundaries.
            cell_values (:obj:`list`): Optional cell count size array of values. Gives
                                       polygons for each contiguous value if specified.
        """
        self._instance = _xmsconstraint.ugrid.UGridBoundaries()
        if grid is not None:
            if isinstance(grid, Grid):
                grid = grid.ugrid
            if cell_values is None:
                cell_values = []
            self._instance.SetGrid(grid._instance, target_cells, cell_values)

    def set_grid(self, grid: Union[Grid, UGrid], target_cells: bool = False,
                 cell_values: Union[Sequence, None] = None):
        """Set the grid to get the boundaries from.

        Args:
            grid (UGrid): Grid to find the boundaries of.
            target_cells: Whether to look for cell or point boundaries.
            cell_values (:obj:`list`): Optional cell count size array of values. Gives
                                       polygons for each contiguous value if specified.
        """
        if isinstance(grid, Grid):
            grid = grid.ugrid
        if cell_values is None:
            cell_values = []
        self._instance.SetGrid(grid._instance, target_cells, cell_values)

    def get_loops(self):
        """Get boundary loops.

        Returns:
            (dict): Returns a dict with a key of loop IDs. The value is a dict containing "ids" for point/cell
            IDs and "locations" containing cell locations.
        """
        return self._instance.GetLoops()

    def get_value_loops(self):
        """Get boundary loops for cell values.

        Returns:
            (dict): Returns a dict with a key of cell value. The value is a list containing loop IDs.
        """
        return self._instance.GetValueLoops()
